package w83b.w83bDAO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bCertificacionesBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCertificacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bConveniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bEscrutiniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMunicipiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bProvinciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bRespAreaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bResultadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;


public class W83bCertificacionesDAO implements W83bICertificacionesDAO{
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	
	
	public W83bCertificacionesBean cargaCertificacionNumDelCentSind(W83bCertificacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		
		//obtengo los delegados
		strSql = new StringBuffer();
		
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		strSql.append("SELECT NVL(SUM(CONSULTA.").append(W83bCertificacionesBD.numdelegados).append("),0) ").append(W83bCertificacionesBD.vistas_delegados);
		strSql.append(" FROM (SELECT ACTA.").append(W83bActasBD.numActa).append(" as ").append(W83bActasBD.num_acta);
		strSql.append(", ACTA.").append(W83bActasBD.anyoActa).append(" as ").append(W83bActasBD.ano_acta);
		strSql.append(", ACTA.").append(W83bActasBD.codTerritActa).append(" as ").append(W83bActasBD.codTerritorioActa);
		strSql.append(", ACTA.").append(W83bActasBD.versionActa).append(" as ").append(W83bActasBD.version_acta);
		strSql.append(", NVL (SUM (");
		strSql.append(" DEL.").append(W83bEscrutiniosBD.delegadosMujeres);
		strSql.append("+");
		strSql.append(" DEL.").append(W83bEscrutiniosBD.delegadosHombres);
		strSql.append("),'0')");
		strSql.append(" AS ");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista).append(" DEL,").append(W83bActasBD.actasTable).append(" ACTA ");
		strSql.append(" WHERE DEL.").append(W83bEscrutiniosBD.acta).append(" = ACTA.").append(W83bActasBD.numActa);
	    strSql.append(" AND DEL.").append(W83bEscrutiniosBD.anyoActa).append(" = ACTA.").append(W83bActasBD.anyoActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.versionActa).append(" = ACTA.").append(W83bActasBD.versionActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.territorioActa).append(" = ACTA.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.codSind).append(" = ? ");
		strSql.append(" AND (ACTA.").append(W83bActasBD.fechaBaja).append(" IS NULL ");
	    strSql.append(" OR ACTA.").append(W83bActasBD.fechaBaja).append(" > TO_DATE(?,?))");
		strSql.append(" AND ACTA.").append(W83bActasBD.numTotalActa).append(" IS NULL ");
		strSql.append(" AND ACTA.").append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND TO_DATE(?,?)<=ACTA.").append(W83bActasBD.fechaEleccion).append(" AND TO_DATE(?,?)>=ACTA.").append(W83bActasBD.fechaEleccion);
		strSql.append(" AND TO_DATE(?,?)>=ACTA.").append(W83bActasBD.fecRegDefinitivo);
		strSql.append(" AND ACTA.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA);
		strSql.append(" GROUP BY ");
		strSql.append("ACTA.").append(W83bActasBD.numActa);
		strSql.append(", ACTA.").append(W83bActasBD.anyoActa);
		strSql.append(", ACTA.").append(W83bActasBD.codTerritActa);
		strSql.append(", ACTA.").append(W83bActasBD.versionActa);
		strSql.append(") CONSULTA ");
		strSql.append(" WHERE CONSULTA.").append(W83bActasBD.version_acta).append(" = ");
		strSql.append(" (SELECT MAX (").append(W83bActasBD.versionActa).append(") ");
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" ACT "); 
		strSql.append(" WHERE CONSULTA.").append(W83bActasBD.num_acta).append(" = ACT.").append(W83bActasBD.numActa);
		strSql.append(" AND CONSULTA.").append(W83bActasBD.ano_acta).append(" = ACT.").append(W83bActasBD.anyoActa);
		strSql.append(" AND CONSULTA.").append(W83bActasBD.codTerritorioActa).append(" = ACT.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND (ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL)");
		strSql.append(" AND ACT.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
		strSql.append(" UNION ALL ");		
		strSql.append("SELECT NVL (SUM(CONSULTA.").append(W83bCertificacionesBD.numdelegados).append("),0) ").append(W83bCertificacionesBD.vistas_delegados).append(" FROM");
		strSql.append("(SELECT ACTA.").append(W83bActasBD.numActa).append(" as ").append(W83bActasBD.num_acta);
		strSql.append(", ACTA.").append(W83bActasBD.anyoActa).append(" as ").append(W83bActasBD.ano_acta);
		strSql.append(", ACTA.").append(W83bActasBD.codTerritActa).append(" as ").append(W83bActasBD.codTerritorioActa);
		strSql.append(", ACTA.").append(W83bActasBD.versionActa).append(" as ").append(W83bActasBD.version_acta);
		strSql.append(", NVL (SUM (");
		strSql.append(" DEL.").append(W83bEscrutiniosBD.delegadosMujeres);
		strSql.append("+");
		strSql.append(" DEL.").append(W83bEscrutiniosBD.delegadosHombres);
		strSql.append("),'0')");
		strSql.append(" AS ");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista).append(" DEL, ").append(W83bActasBD.actasTable).append(" ACTA "); 
		strSql.append(" WHERE DEL.").append(W83bEscrutiniosBD.acta).append(" = ACTA.").append(W83bActasBD.numActa);
	    strSql.append(" AND DEL.").append(W83bEscrutiniosBD.anyoActa).append(" = ACTA.").append(W83bActasBD.anyoActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.versionActa).append(" = ACTA.").append(W83bActasBD.versionActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.territorioActa).append(" = ACTA.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND (ACTA.").append(W83bActasBD.fechaBaja).append(" IS NULL ");
	    strSql.append(" OR ACTA.").append(W83bActasBD.fechaBaja).append(" > TO_DATE(?,?))");
		strSql.append(" AND ACTA.").append(W83bActasBD.numTotalActa).append(" IS NULL ");
		strSql.append(" AND ACTA.").append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND TO_DATE(?,?)<=ACTA.").append(W83bActasBD.fechaEleccion).append(" AND TO_DATE(?,?)>=ACTA.").append(W83bActasBD.fechaEleccion);
		strSql.append(" AND TO_DATE(?,?)>=ACTA.").append(W83bActasBD.fecRegDefinitivo);
		strSql.append(" AND ACTA.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA);
		strSql.append(" GROUP BY ");
		strSql.append("ACTA.").append(W83bActasBD.numActa);
		strSql.append(", ACTA.").append(W83bActasBD.anyoActa);
		strSql.append(", ACTA.").append(W83bActasBD.codTerritActa);
		strSql.append(", ACTA.").append(W83bActasBD.versionActa);
		strSql.append(") CONSULTA ");
		strSql.append(" WHERE CONSULTA.").append(W83bActasBD.version_acta).append(" = ");
		strSql.append(" (SELECT MAX (").append(W83bActasBD.versionActa).append(") ");
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" ACT "); 
		strSql.append(" WHERE CONSULTA.").append(W83bActasBD.num_acta).append(" = ACT.").append(W83bActasBD.numActa);
		strSql.append(" AND CONSULTA.").append(W83bActasBD.ano_acta).append(" = ACT.").append(W83bActasBD.anyoActa);
		strSql.append(" AND CONSULTA.").append(W83bActasBD.codTerritorioActa).append(" = ACT.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND (ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL)");
		strSql.append(" AND ACT.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
		params.add(param.getSindicato());
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaRegistroDefinitivo());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaRegistroDefinitivo());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		List listaTiposDocsAux=null;
		
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, "actas");
		param.setDelegadosSindicato(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getDelegados());
		param.setDelegados(((W83bCertificacionesBean)listaTiposDocsAux.get(1)).getDelegados());
		params.clear();
		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		return param;
	}
	public W83bCertificacionesBean cargaCertificacionSindMasRepresent(W83bCertificacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		
		//obtengo los delegados
		strSql = new StringBuffer();
		
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		strSql.append("SELECT ");
		strSql.append("NVL (SUM (");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append("), 0) ");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(", ");
		strSql.append(W83bCertificacionesBD.vistas_codSindicato);
		strSql.append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descSindCast);
		strSql.append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descSindEusk);
		StringBuffer strSqltemp=this.rellenarFromCertificadoMasRepresentativo(strSql, "nototal");
		strSql = strSqltemp;
		params=this.rellenarParamsCertificadoMasRepresentativo(param,params);
		strSql.append(" UNION ALL ");
		strSql.append("SELECT ");
		strSql.append("NVL (SUM (");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append("), 0) ");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(",0,'','' ");
		strSql=this.rellenarFromCertificadoMasRepresentativo(strSql,"total");
		params=this.rellenarParamsCertificadoMasRepresentativo(param,params);
		List listaTiposDocsAux=null;	
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, "actas");
		param.setDelegadosSindicato(((W83bCertificacionesBean)listaTiposDocsAux.get(1)).getNumdelegados());
		param.setDescripcionSindicato(((W83bCertificacionesBean)listaTiposDocsAux.get(1)).getDescripcionSindicato());
		param.setDescripcionSindicatoEusk(((W83bCertificacionesBean)listaTiposDocsAux.get(1)).getDescripcionSindicatoEusk());
		param.setSindicato(((W83bCertificacionesBean)listaTiposDocsAux.get(1)).getSindicato());
		param.setDelegados(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getNumdelegados());
		params.clear();
		return param;
	}
	public List cargaCertificacionCentSind(W83bCertificacionesBean param, String texto) throws Exception {
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		//obtengo los delegados
		strSql = new StringBuffer();
		params = new ArrayList();
		
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		strSql.append("SELECT ");
		strSql.append(" NVL(SUM(CASE WHEN(").append(W83bActasBD.territ).append("=").append(W83bClsConstantes.CONSTANTE_ALAVA).append(") THEN ").append(W83bCertificacionesBD.numdelegados).append(" ELSE 0 END),0) as ").append(W83bCertificacionesBD.vistas_alava).append(",");
		strSql.append(" NVL(SUM(CASE WHEN(").append(W83bActasBD.territ).append("=").append(W83bClsConstantes.CONSTANTE_BIZKAIA).append(") THEN ").append(W83bCertificacionesBD.numdelegados).append(" ELSE 0 END),0) as ").append(W83bCertificacionesBD.vistas_vizcaya).append(",");
		strSql.append(" NVL(SUM(CASE WHEN(").append(W83bActasBD.territ).append("=").append(W83bClsConstantes.CONSTANTE_GIPUZKOA).append(") THEN ").append(W83bCertificacionesBD.numdelegados).append(" ELSE 0 END),0) as ").append(W83bCertificacionesBD.vistas_guipuzcoa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_codConvenio);
		strSql.append(",");
		strSql.append(W83bCertificacionesBD.vistas_descConvenio);
		strSql.append(",");
		strSql.append(W83bCertificacionesBD.vistas_deseConvenio);
		strSql=this.rellenarFromCertificacionCentSindPrimeraParte(strSql,param.getListaCodConvenios().split(","),texto);
		params=this.rellenarParamsCertificacionCentSind(param, texto);
		
		List listaTiposDocsAux=null;	
		
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, "actas");
		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		return listaTiposDocsAux;
	}
	
	private StringBuffer rellenarFromCertificacionCentSindPrimeraParte(	StringBuffer sql,String[] codigos, String texto) {
		StringBuffer strSql=sql;
		strSql.append(" FROM ").append(W83bCertificacionesBD.certCentralTerritorio);
		strSql.append(" WHERE ");
		if ("individual".equals(texto)){
			strSql.append(W83bCertificacionesBD.codsindi).append(" = ? ");
			strSql.append(" AND ");
		}
		strSql.append("(").append(W83bCertificacionesBD.fechabaja).append(" IS NULL ");
	    strSql.append(" OR ").append(W83bCertificacionesBD.fechabaja).append(" > TO_DATE(?,?))");
		strSql.append(" AND TO_DATE(?,?)<=").append(W83bCertificacionesBD.felec).append(" AND TO_DATE(?,?)>=").append(W83bCertificacionesBD.felec);
		strSql.append(" AND TO_DATE(?,?)>=").append(W83bCertificacionesBD.fregdef);
		if (codigos!=null){
			for(int i=0;i<codigos.length;i++){
				if(i==0)
				{
					 strSql.append(" AND (");
				}else{
					strSql.append(" OR ");
				}
				 strSql.append(W83bCertificacionesBD.vistas_codConvenio).append(" = ? ");
				if(i==codigos.length-1)
				{
					 strSql.append(" ) ");
				}
		    }
		}
		strSql.append(" AND ").append(W83bCertificacionesBD.vers).append(" = ");
		strSql.append(" (SELECT MAX (").append(W83bActasBD.versionActa).append(") ");
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" ACT "); 
		strSql.append(" WHERE ").append(W83bCertificacionesBD.nacta).append(" = ACT.").append(W83bActasBD.numActa);
		strSql.append(" AND ").append(W83bCertificacionesBD.anoacta).append(" = ACT.").append(W83bActasBD.anyoActa);
		strSql.append(" AND ").append(W83bCertificacionesBD.territ).append(" = ACT.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND (ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL)");
		strSql.append(" AND ACT.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
		strSql.append(" GROUP BY ");
		strSql.append(W83bCertificacionesBD.vistas_codConvenio);
		strSql.append(",");
		strSql.append(W83bCertificacionesBD.vistas_descConvenio);
		strSql.append(",");
		strSql.append(W83bCertificacionesBD.vistas_deseConvenio);
		strSql.append(" ORDER BY ");
		strSql.append(W83bCertificacionesBD.vistas_codConvenio);
		return strSql;
	}
	private StringBuffer rellenarFromCertificadoMasRepresentativo(StringBuffer sql, String texto) {
		StringBuffer strSql=sql;
		strSql.append(" FROM ").append(W83bCertificacionesBD.certMasRepresentativo);
		strSql.append(" WHERE ");
		strSql.append("(").append(W83bCertificacionesBD.fechabaja).append(" IS NULL ");
	    strSql.append(" OR ").append(W83bCertificacionesBD.fechabaja).append(" > TO_DATE(?,?))");
		strSql.append(" AND TO_DATE(?,?)<=").append(W83bCertificacionesBD.felec).append(" AND TO_DATE(?,?)>=").append(W83bCertificacionesBD.felec);
		strSql.append(" AND TO_DATE(?,?)>=").append(W83bCertificacionesBD.fregdef);
		strSql.append(" AND ").append(W83bCertificacionesBD.vers).append(" = ");
		strSql.append(" (SELECT MAX (").append(W83bActasBD.versionActa).append(") ");
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" ACT "); 
		strSql.append(" WHERE ").append(W83bCertificacionesBD.nacta).append(" = ACT.").append(W83bActasBD.numActa);
		strSql.append(" AND ").append(W83bCertificacionesBD.anoacta).append(" = ACT.").append(W83bActasBD.anyoActa);
		strSql.append(" AND ").append(W83bCertificacionesBD.territ).append(" = ACT.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND (ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL)");
		strSql.append(" AND ACT.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
		if ("nototal".equals(texto)){
			strSql.append(" GROUP BY ");
			strSql.append(W83bCertificacionesBD.vistas_codSindicato);
			strSql.append(",");
			strSql.append(W83bCertificacionesBD.vistas_descSindCast);
			strSql.append(",");
			strSql.append(W83bCertificacionesBD.vistas_descSindEusk);
		}
		if ("total".equals(texto)){
			strSql.append(" ORDER BY ");
			strSql.append(W83bCertificacionesBD.numdelegados); 
			strSql.append(" DESC ");
			strSql.append(" , ");
			strSql.append(W83bCertificacionesBD.vistas_codSindicato);
			strSql.append(" ASC ");
		}
		
		return strSql;
	}
	public List cargaCertificacionSindConv(W83bCertificacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		String[] codigos=param.getListaCodConvenios().split(",");
		//obtengo los delegados
		strSql = new StringBuffer();
		params = new ArrayList();
		
		
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
	    
		strSql.append("SELECT ").append(W83bCertificacionesBD.vistas_siglas).append(", ").append(W83bCertificacionesBD.vistas_codConvenio).append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descConvenio).append(", ").append(W83bCertificacionesBD.vistas_deseConvenio).append(", ");
		if(StringUtils.isNotEmpty(param.getTerritorio())&& !W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(param.getTerritorio()) ){
			if(param.getTerritorio().equals(W83bClsConstantes.CONSTANTE_ALAVA)){
				strSql.append(" sum(").append(W83bCertificacionesBD.numdelegados).append(") as ").append(W83bCertificacionesBD.vistas_alava);
			}
			if(param.getTerritorio().equals(W83bClsConstantes.CONSTANTE_BIZKAIA)){
				strSql.append(" sum(").append(W83bCertificacionesBD.numdelegados).append(") as ").append(W83bCertificacionesBD.vistas_vizcaya);
			}
			if(param.getTerritorio().equals(W83bClsConstantes.CONSTANTE_GIPUZKOA)){
				strSql.append(" sum(").append(W83bCertificacionesBD.numdelegados).append(") as ").append(W83bCertificacionesBD.vistas_guipuzcoa);
			}
		}
		else{
			strSql.append(" NVL(SUM(CASE WHEN(").append(W83bActasBD.codTerritorioActa).append("=").append(W83bClsConstantes.CONSTANTE_ALAVA).append(") THEN ").append(W83bCertificacionesBD.numdelegados).append (" ELSE 0 END),0) as ").append(W83bCertificacionesBD.vistas_alava).append(",");
			strSql.append(" NVL(SUM(CASE WHEN(").append(W83bActasBD.codTerritorioActa).append("=").append(W83bClsConstantes.CONSTANTE_BIZKAIA).append(") THEN ").append(W83bCertificacionesBD.numdelegados).append (" ELSE 0 END),0) as ").append(W83bCertificacionesBD.vistas_vizcaya).append(",");
			strSql.append(" NVL(SUM(CASE WHEN(").append(W83bActasBD.codTerritorioActa).append("=").append(W83bClsConstantes.CONSTANTE_GIPUZKOA).append(") THEN ").append(W83bCertificacionesBD.numdelegados).append (" ELSE 0 END),0) as ").append(W83bCertificacionesBD.vistas_guipuzcoa);
		}
		strSql.append(" FROM ");
		strSql.append(" (SELECT ACTA.").append(W83bActasBD.numActa).append(" AS NUMACTA, ");
		strSql.append(" ACTA.").append(W83bActasBD.anyoActa).append(" AS ANO_ACTA, ");
		strSql.append(" ACTA.").append(W83bActasBD.codTerritActa).append(" AS CODTERRITORIOACTA, ");
	    strSql.append(" ACTA.").append(W83bActasBD.versionActa).append(" AS VERSIONACTA, ");
	    strSql.append(" DEL.").append(W83bEscrutiniosBD.codSind).append(" AS SINDICATO, ");
	    strSql.append(" SIND.").append(W83bSindicatosBD.siglas).append(" AS SIGLAS, ");
	    strSql.append(" CONV.").append(W83bConveniosBD.descripcion).append(" AS DESCCONVENIO, ");
	    strSql.append(" CONV.").append(W83bConveniosBD.descripcion_eusk).append(" AS DESECONVENIO, ");
	    strSql.append(" ACTA.").append(W83bActasBD.codConvenio).append(" AS CODCONVENIO, ");
	    strSql.append("NVL (SUM (");
	    strSql.append(" DEL.").append(W83bEscrutiniosBD.delegadosMujeres);
	    strSql.append("+");
	    strSql.append(" DEL.").append(W83bEscrutiniosBD.delegadosHombres);
	    strSql.append("),'0')");
	    strSql.append(" AS ");
	    strSql.append(W83bCertificacionesBD.numdelegados);
	    strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista).append(" DEL ");
	    strSql.append(", ").append(W83bActasBD.actasTable).append(" ACTA ");
	    strSql.append("  , ").append(W83bSindicatosBD.sindicatosVista).append(" SIND ");
	    strSql.append("  , ").append(W83bConveniosBD.convenioTable).append(" CONV ");
	    strSql.append(" WHERE DEL.").append(W83bEscrutiniosBD.acta).append(" = ACTA.").append(W83bActasBD.numActa);
	    strSql.append(" AND DEL.").append(W83bEscrutiniosBD.anyoActa).append(" = ACTA.").append(W83bActasBD.anyoActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.versionActa).append(" = ACTA.").append(W83bActasBD.versionActa);
		strSql.append(" AND DEL.").append(W83bEscrutiniosBD.territorioActa).append(" = ACTA.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND CONV.").append(W83bConveniosBD.codigo).append(" = ACTA.").append(W83bActasBD.codConvenio);
		strSql.append(" AND SIND.").append(W83bSindicatosBD.codSindicato).append(" = DEL.").append(W83bEscrutiniosBD.codSind);
		if(StringUtils.isNotEmpty(param.getTerritorio())&& !W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(param.getTerritorio()))
			{
				strSql.append(" AND ACTA.").append(W83bActasBD.codTerritActa).append(" = ? ");
			}
				
		for(int i=0;i<codigos.length;i++){
			if(i==0)
			{
				 strSql.append(" AND (");
			}else{
				strSql.append(" OR");
			}
			 strSql.append(" ACTA.").append(W83bActasBD.codConvenio).append(" = ? ");
			if(i==codigos.length-1)
			{
				 strSql.append(" ) ");
			}
	    }
	   
	    strSql.append(" AND (ACTA.").append(W83bActasBD.fechaBaja).append(" IS NULL ");
	    strSql.append(" OR ACTA.").append(W83bActasBD.fechaBaja).append(" > TO_DATE(?,?))");
		strSql.append(" AND ACTA.").append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND ACTA.").append(W83bActasBD.numTotalActa).append(" IS NULL ");
	    strSql.append(" AND TO_DATE(?,?)<=ACTA.").append(W83bActasBD.fechaEleccion);
	    strSql.append(" AND TO_DATE(?,?)>=ACTA.").append(W83bActasBD.fechaEleccion);
	    strSql.append(" AND TO_DATE(?,?)>=ACTA.").append(W83bActasBD.fecRegDefinitivo);
	    strSql.append(" AND ACTA.").append(W83bActasBD.validada).append(" =").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(" ");
	    strSql.append(" GROUP BY ");
	    strSql.append(" ACTA.").append(W83bActasBD.numActa).append(",");
		strSql.append(" ACTA.").append(W83bActasBD.anyoActa).append(",");
		strSql.append(" ACTA.").append(W83bActasBD.codTerritActa).append(",");
	    strSql.append(" ACTA.").append(W83bActasBD.versionActa).append(",");
	    strSql.append(" DEL.").append(W83bEscrutiniosBD.codSind).append(",");
	    strSql.append(" SIND.").append(W83bSindicatosBD.siglas).append(",");
	    strSql.append(" CONV.").append(W83bConveniosBD.descripcion).append(",");
	    strSql.append(" CONV.").append(W83bConveniosBD.descripcion_eusk).append(",");
	    strSql.append(" ACTA.").append(W83bActasBD.codConvenio);
	    strSql.append(") CONSULTA ");
	    strSql.append(" WHERE CONSULTA.").append(W83bActasBD.version_acta).append(" = ");
	    strSql.append(" (SELECT MAX (").append(W83bActasBD.versionActa).append(") ");
	    strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" ACT ");
	    strSql.append(" WHERE CONSULTA.").append(W83bActasBD.num_acta).append(" = ACT.").append(W83bActasBD.numActa);
	    strSql.append(" AND CONSULTA.").append(W83bActasBD.ano_acta).append(" = ACT.").append(W83bActasBD.anyoActa);
	    strSql.append(" AND CONSULTA.").append(W83bActasBD.codTerritorioActa).append(" = ACT.").append(W83bActasBD.codTerritActa);
	    strSql.append(" AND (ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
	    strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL)");
	    strSql.append(" AND ACT.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
	    strSql.append(" GROUP BY SIGLAS,CODCONVENIO,DESCCONVENIO,DESECONVENIO ");
	    strSql.append(" ORDER BY ");
	    if(StringUtils.isNotEmpty(param.getTerritorio())&& !W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(param.getTerritorio()) ){
			if(param.getTerritorio().equals(W83bClsConstantes.CONSTANTE_ALAVA)){
				strSql.append(W83bCertificacionesBD.vistas_alava);
			}
			if(param.getTerritorio().equals(W83bClsConstantes.CONSTANTE_BIZKAIA)){
				strSql.append(W83bCertificacionesBD.vistas_vizcaya);
			}
			if(param.getTerritorio().equals(W83bClsConstantes.CONSTANTE_GIPUZKOA)){
				strSql.append(W83bCertificacionesBD.vistas_guipuzcoa);
			}
		}
		else{
			strSql.append(W83bCertificacionesBD.vistas_alava).append("+");
			strSql.append(W83bCertificacionesBD.vistas_vizcaya).append("+");
			strSql.append(W83bCertificacionesBD.vistas_guipuzcoa);
		}
	    strSql.append(" DESC ");
		List listaTiposDocsAux=null;
		
		if(StringUtils.isNotEmpty(param.getTerritorio())&& !W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(param.getTerritorio()) )
		{
	
				params.add(param.getTerritorio());
		}
	
		
		for(int i=0;i<codigos.length;i++){
	    	 params.add(codigos[i]);
	    }
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaRegistroDefinitivo());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, param.getIdioma());
		
			
		
		
		params.clear();
		
		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		
		return listaTiposDocsAux;
	}
	public W83bCertificacionesBean cargaDatosGeneralesCertificacionOrganoRepresentacion(W83bCertificacionesBean param) throws Exception {
		
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		
		strSql = new StringBuffer();
		params = new ArrayList();
		
		strSql.append("SELECT ").append(W83bCertificacionesBD.vistas_actaTotal).append(",");
		strSql.append(W83bCertificacionesBD.vistas_numActa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_anyoActa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append(",TO_CHAR(");
		strSql.append(W83bCertificacionesBD.vistas_fechaEleccion).append(",?) ").append(W83bCertificacionesBD.vistas_fechaEleccion).append(",");
		strSql.append(W83bCertificacionesBD.vistas_razon).append(",");
		strSql.append(W83bMunicipiosBD.nomMunic_Cast).append(" AS ").append(W83bCertificacionesBD.vistas_municipio).append(",");
		strSql.append(W83bCertificacionesBD.vistas_cifCentro).append(" FROM ").append(W83bCertificacionesBD.vistaOrganoRepr);
		strSql.append(",").append(W83bMunicipiosBD.municipiosTable);
	
		strSql.append(" WHERE ").append(W83bCertificacionesBD.vistas_cifCentro).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_numeroCentro).append("=? ").append(" AND ");
		strSql.append(W83bCertificacionesBD.vistas_codprovincia).append("= ").append(W83bMunicipiosBD.codProvincia).append(" AND ");
		strSql.append(W83bCertificacionesBD.vistas_codmunicipio).append("= ").append(W83bMunicipiosBD.codMunic).append(" AND ");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append("=? ");
		strSql.append(" ORDER BY ").append(W83bCertificacionesBD.vistas_anyoActa).append(" DESC ");
				
		List listaTiposDocsAux=null;
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getCifnif());
		params.add(param.getNumCentro());
		params.add(param.getTerritorio());
		
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, "actas");
		if(listaTiposDocsAux.size()>0){
			param.setActaCompleto(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getActaCompleto());
			param.setFechaEleccion(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getFechaEleccion());
			param.setEmpresa(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getEmpresa());
			param.setMunicipio(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getMunicipio());
			param.setCifnif(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getCifnif());
			param.setNumActa(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getNumActa());
			param.setAnyoActa(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getAnyoActa());
			param.setTerritorio(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getTerritorio());
		}
		params.clear();
		
		return param;
	}
	public W83bCertificacionesBean cargaCertificacionEmpresa(W83bCertificacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		
		//obtengo los delegados
		strSql = new StringBuffer();
		params = new ArrayList();
		strSql.append("SELECT ").append(W83bCertificacionesBD.vistas_siglas).append(",");
		strSql.append(W83bCertificacionesBD.vistas_razon).append(",");
		strSql.append(W83bCertificacionesBD.vistas_descSindCast).append(",");
		strSql.append(W83bCertificacionesBD.vistas_descSindEusk).append(",");
		strSql.append(W83bCertificacionesBD.vistas_codCentro).append(",TO_CHAR(");
		strSql.append(W83bCertificacionesBD.vistas_fechaEleccion).append(",?) ").append(W83bCertificacionesBD.vistas_fechaEleccion).append(",");
		strSql.append(W83bCertificacionesBD.vistas_codSindicato).append(",TO_CHAR(");
		strSql.append(W83bCertificacionesBD.vistas_fechaAlta).append(",?) ").append(W83bCertificacionesBD.vistas_fechaAlta).append(",");
		strSql.append(W83bCertificacionesBD.vistas_numRegistro).append(",TO_CHAR(");
		strSql.append(W83bCertificacionesBD.vistas_fechaRegistro).append(",?) ").append(W83bCertificacionesBD.vistas_fechaRegistro).append(",");
		strSql.append(W83bCertificacionesBD.vistas_observaciones).append(",");
		strSql.append(W83bCertificacionesBD.vistas_actaTotal).append(",");
		strSql.append(W83bCertificacionesBD.vistas_numActa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_anyoActa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_alava).append(",");
		strSql.append(W83bCertificacionesBD.vistas_vizcaya).append(",");
		strSql.append(W83bCertificacionesBD.vistas_guipuzcoa);
		strSql.append(" FROM ").append(W83bCertificacionesBD.vistaEmpresa).append(" WHERE ");
		strSql.append(W83bCertificacionesBD.vistas_cifCentro).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_numeroCentro).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_anyoActa).append(" = ( SELECT max(");
		strSql.append(W83bCertificacionesBD.vistas_anyoActa);
		strSql.append(") FROM ").append(W83bCertificacionesBD.vistaEmpresa).append(" WHERE ");
		strSql.append(W83bCertificacionesBD.vistas_cifCentro).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_numeroCentro).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append("=?) ");
		
		
		strSql.append(" ORDER BY ");
		strSql.append(W83bCertificacionesBD.vistas_anyoActa).append(" DESC, ");
		strSql.append(W83bCertificacionesBD.vistas_codSindicato).append(" ASC ");

		
		List listaTiposDocsAux=null;
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getCifnif());
		params.add(param.getNumCentro());
		params.add(param.getTerritorio());
		params.add(param.getCifnif());
		params.add(param.getNumCentro());
		params.add(param.getTerritorio());
		
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, "actas");
		if(listaTiposDocsAux.size()>0){
			param.setActaCompleto(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getActaCompleto());
			param.setFechaEleccion(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getFechaEleccion());
			param.setFechaAlta(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getFechaAlta());
			param.setCodCentro(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getCodCentro());
			param.setRazon(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getRazon());
			param.setNumeroRegistroDefinitivo(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getNumeroRegistroDefinitivo());
			param.setFechaRegistroDefinitivo(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getFechaRegistroDefinitivo());
			param.setObservaciones(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getObservaciones());
			param.setNumActa(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getNumActa());
			param.setAnyoActa(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getAnyoActa());
			param.setTerritorio(((W83bCertificacionesBean)listaTiposDocsAux.get(0)).getTerritorio());
		}
		
			
		param.setListaDelegados(listaTiposDocsAux);
		params.clear();
		
		
		
		return param;
	}
	
	public List cargaListaDelegados (W83bCertificacionesBean param) throws Exception {
		
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		
		strSql = new StringBuffer();
		params = new ArrayList();
		
        
		strSql.append(" SELECT DISTINCT ");
		strSql.append(W83bCertificacionesBD.vistas_nombre).append(",");
		strSql.append(W83bCertificacionesBD.vistas_apellido1).append(",");
		strSql.append(W83bCertificacionesBD.vistas_apellido2).append(",");
		strSql.append(W83bCertificacionesBD.vistas_dni).append(",");
		strSql.append(W83bCertificacionesBD.vistas_siglas).append(",TO_CHAR(");
		strSql.append(W83bCertificacionesBD.vistas_fechaAlta).append(",?) ").append(W83bCertificacionesBD.vistas_fechaAlta).append(",");
		strSql.append(W83bCertificacionesBD.vistas_siglas);
		//NOMBRE,APELLIDO1,APELLIDO2,DNI,SIGLAS,TO_CHAR(FECHAALTA,?) AS FECHAALTA ");
		strSql.append(" FROM ").append(W83bCertificacionesBD.vistaListaDelegados);
		strSql.append(" WHERE ");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_anyoActa).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_numActa).append("=? ");
		strSql.append(" ORDER BY ").append(W83bCertificacionesBD.vistas_dni).append(" ASC ");
		
		List listaTiposDocsAux=null;
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getTerritorio());
		params.add(param.getAnyoActa());
		params.add(param.getNumActa());
		
		
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,null, "actas");
		

		
		params.clear();
		
		return listaTiposDocsAux;
	}
	
	/**
	 * Recupera el nombre de un firmante teniendo en cuenta el territorio y el firmante seleccionado
	 * @param W83bCertificacionesBean param  
	 * @return String el nombre del firmante
	 * @throws Exception
	 */
	public String recuperarNombreFirmante(W83bCertificacionesBean param) throws Exception {
		
		
		
		String nombreFirmante ="";
		
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		
		strSql.append("SELECT ");
		strSql.append( "DECODE (").append(W83bRespAreaBD.responsable).append(", ").append("null, ' ',").append(W83bRespAreaBD.responsable).append(")"); 
		strSql.append( "||'|'||");
		strSql.append( "DECODE (").append(W83bRespAreaBD.sexo).append(", ").append("null, ' ',").append(W83bRespAreaBD.sexo).append(")"); 
		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable);				
		
		strSql.append(" WHERE ");
		strSql.append(W83bRespAreaBD.territorio).append(" = ? ").append("AND ");
		strSql.append(W83bRespAreaBD.perfil).append(" = ? ").append("AND ");
		strSql.append(W83bRespAreaBD.baja).append(" is null");
		
		params.add(param.getTerritorio());
		params.add(param.getCargo());
		
		
		List listaRespArea = W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		if(!listaRespArea.isEmpty()){
			if(StringUtils.isNotEmpty((String)listaRespArea.get(0))){
				nombreFirmante = listaRespArea.get(0).toString();
			}else{
				nombreFirmante = "";
			}
		}
		
		
		return nombreFirmante;
	}
	/**
	 * Recupera el cargo de un firmante teniendo en cuenta el territorio y el firmante seleccionado
	 * @param W83bCertificacionesBean param  
	 * @return String el nombre del firmante
	 * @throws Exception
	 */
	public String recuperarCargoFirmante(W83bCertificacionesBean param) throws Exception {
		
		
		
		String cargoFirmante ="";
		
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		
		strSql.append("SELECT ");
		strSql.append( W83bRespAreaBD.perfildesc).append("||'#'||").append(W83bRespAreaBD.perfilfemenino).append("||'#'||").append( W83bRespAreaBD.perfildese);
		
		strSql.append(" FROM ").append(W83bRespAreaBD.perfilesTable);				
		
		strSql.append(" WHERE ");
		
		strSql.append(W83bRespAreaBD.codperfil).append(" = ? ");
				
		params.add(param.getCargo());
		
		
		List listaRespArea = W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		if(!listaRespArea.isEmpty()){
			cargoFirmante = listaRespArea.get(0).toString();
		}
		
		
		return cargoFirmante;
	}
	
	
	/**
	 * Recupera el cdigo de la localidad del territorio
	 * @param W83bCertificacionesBean param  
	 * @return String el cdigo de la localidad del territorio
	 * @throws Exception
	 */
	public String recuperarLocalidadFirmante(W83bCertificacionesBean param) throws Exception {
		
		String descLocalidad = "";
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		strSql.append("SELECT MUN.");
		strSql.append(W83bMunicipiosBD.nomMunic_Cast).append("||'#'||MUN.").append(W83bMunicipiosBD.nomMunic_Eusk);
		strSql.append("||'#'||PRO.").append(W83bProvinciasBD.nomProvinc_Cast).append("||'#'||PRO.").append(W83bProvinciasBD.nomProvinc_Eusk);
		strSql.append(" FROM ");
		strSql.append(W83bCertificacionesBD.delegacionesTable).append(", ");
		strSql.append(W83bMunicipiosBD.municipiosTable).append(" MUN, ");
		strSql.append(W83bProvinciasBD.provinciasTable).append(" PRO");
		strSql.append(" WHERE ");
		strSql.append(W83bCertificacionesBD.territorio).append(" = ?").append(" AND ");
		strSql.append(W83bMunicipiosBD.codProvincia).append(" = ").append(W83bCertificacionesBD.territorio2).append(" AND ");
		strSql.append(" MUN.").append(W83bMunicipiosBD.codMunic).append(" = ").append(W83bCertificacionesBD.localidad).append(" AND ");
		strSql.append(W83bMunicipiosBD.codProvincia).append(" = MUN.").append(W83bMunicipiosBD.codProvincia).append(" AND PRO.");
		strSql.append(W83bProvinciasBD.codProvinc).append(" = ").append(W83bCertificacionesBD.territorio2);
		
		
		if("".equals(param.getTerritorio())){
			params.add(param.getUsuarioBean().getCodTerritorioDelegacion());
		}else{
			params.add(param.getTerritorio());	
		}
		
		
		
		
		List listaLocalidad = W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		if(!listaLocalidad.isEmpty()){
			descLocalidad = listaLocalidad.get(0).toString();
		}
		
		return descLocalidad;
	}
	
	/**
	 * Recupera el cdigo del sindicato seleccionado
	 * @param W83bCertificacionesBean param  
	 * @return String el cdigo del sindicato seleccionado
	 * @throws Exception
	 */
	public String recuperarCodigoSindicato(W83bCertificacionesBean param) throws Exception {
		
		
		String siglasSindicato = "";
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		strSql.append("SELECT ");
		strSql.append(W83bSindicatosBD.siglas);
		strSql.append(" FROM ");
		strSql.append(W83bSindicatosBD.sindicatosVista);
		strSql.append(" WHERE ");
		strSql.append(W83bSindicatosBD.codSindicato).append(" = ?");
		
		params.add(param.getSindicato());
		
		List listaSiglas= W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		if(!listaSiglas.isEmpty()){
			siglasSindicato = listaSiglas.get(0).toString();
		}
		
		return siglasSindicato;
	}
	public String cargaCertificacionNegativoConvocatoria(W83bCertificacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT COUNT(");
		strSql.append(W83bActasBD.numActa);
		strSql.append(") FROM ");
		strSql.append(W83bActasBD.actasTable);
		strSql.append(" ACTA WHERE ");
		strSql.append(W83bActasBD.codCentro).append(" = ? AND ");
		strSql.append(W83bActasBD.codTerritActa).append(" = ? AND ");
		strSql.append(W83bActasBD.versionActa).append(" = (SELECT MAX (ACT.");
		strSql.append(W83bActasBD.versionActa).append(") FROM ");
		strSql.append(W83bActasBD.actasTable).append("  ACT WHERE ");
		strSql.append(" ACTA.").append(W83bActasBD.numActa).append("=ACT.").append(W83bActasBD.numActa);
		strSql.append(" AND ACTA.").append(W83bActasBD.anyoActa).append("=ACT.").append(W83bActasBD.anyoActa);
		strSql.append(" AND ACTA.").append(W83bActasBD.codTerritActa).append("=ACT.").append(W83bActasBD.codTerritActa);
		strSql.append(" AND ACT.").append(W83bActasBD.validada).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
		
		
		params.add(param.getCodCentro());
		params.add(param.getTerritorio());
		
		List listaActas= W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		return ((BigDecimal)listaActas.get(0)).toString();	
	}
	
	public List cargaDescripcionSindicato(W83bCertificacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List descrip=new ArrayList();
		List params = new ArrayList();
		strSql.append(" SELECT ");
		strSql.append(W83bSindicatosBD.descSindicatoCast).append(",");
		strSql.append(W83bSindicatosBD.descSindicatoEusk);
		strSql.append(" FROM ");
		strSql.append(W83bSindicatosBD.sindicatosVista);	
		strSql.append(" WHERE ");
		strSql.append(W83bSindicatosBD.codSindicato);	
		strSql.append("=?");	
		params.add(param.getSindicato());
		List listaDescrip= W83bDataBase.executeQuery(strSql.toString(),params,W83bSindicatosBean.class,param.getUsuarioBean(),null);
		if (listaDescrip!=null&&listaDescrip.get(0)!=null){
			descrip.add(0,((W83bSindicatosBean)listaDescrip.get(0)).getDescSindicatoCast());
			descrip.add(1,((W83bSindicatosBean)listaDescrip.get(0)).getDescSindicatoEusk());
		}
		return descrip;	
	}
	
	public W83bCertificacionesBean cargaCertificacionNegativoRepresentatividad(W83bCertificacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		
		List params = new ArrayList();
		strSql.append(" SELECT ");
		strSql.append(W83bCertificacionesBD.vistas_numActa).append(",TO_CHAR(");
		strSql.append(W83bCertificacionesBD.vistas_fechaEleccion).append(",'dd/MM/yyyy') ").append(W83bCertificacionesBD.vistas_fechaEleccion).append(",");
		strSql.append(W83bCertificacionesBD.vistas_descSindCast).append(",");
		strSql.append(W83bCertificacionesBD.vistas_descSindEusk).append(",");
		strSql.append(" SUM (").append(W83bCertificacionesBD.numdelegados).append(") AS ").append(W83bCertificacionesBD.numdelegados);
		strSql.append(" FROM ").append(W83bCertificacionesBD.vistaNegRepres);
		strSql.append(", (SELECT   MAX (").append(W83bActasBD.versionActa).append(") AS MAXVER, ");
		strSql.append(W83bActasBD.numActa).append(",").append(W83bActasBD.anyoActa).append(",");
		strSql.append(W83bActasBD.codTerritActa).append(" FROM ").append(W83bActasBD.actasTable).append(" WHERE ");
		
		strSql.append(W83bActasBD.fecRegDefinitivo).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFhist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		strSql.append(" AND ");
		strSql.append(W83bActasBD.fechaEleccion).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		strSql.append(" AND ");
		strSql.append(W83bActasBD.fechaEleccion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=").append("? ");
		params.add(param.getTerritorio());		
		
		strSql.append(" AND (").append(W83bResultadosBD.factu_016).append("<=TO_DATE('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFhist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss') OR ");
		strSql.append(W83bResultadosBD.factu_016).append(" IS NULL )");
		strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1");
		strSql.append(" GROUP BY ").append(W83bResultadosBD.N_ACTA_016).append(",");
		strSql.append(W83bResultadosBD.ANO_ACTA_016).append(",").append(W83bResultadosBD.C_TERRIT_016).append(") MAXRESULTS");
		
		strSql.append(" WHERE ");
		
		strSql.append(" nacta = MAXRESULTS.").append(W83bResultadosBD.N_ACTA_016 );
		strSql.append(" AND ano_acta = MAXRESULTS.").append(W83bResultadosBD.ANO_ACTA_016 );
		strSql.append(" AND territorio_acta = MAXRESULTS.").append(W83bResultadosBD.C_TERRIT_016 );
		strSql.append(" AND ver = MAXRESULTS.").append("maxver" );
		strSql.append(" AND (");
		strSql.append(W83bCertificacionesBD.vistas_codSindicato).append("=? OR ");
		strSql.append(W83bCertificacionesBD.vistas_codSindicato); 
		strSql.append(" IS NULL) AND ");
		strSql.append(W83bCertificacionesBD.vistas_codCentro).append("=? AND ");
		strSql.append(W83bCertificacionesBD.vistas_territorioActa).append("=? AND TO_DATE(?,?)<=");
		strSql.append(W83bCertificacionesBD.vistas_fechaEleccion).append(" AND TO_DATE(?,?)>=");
		strSql.append(W83bCertificacionesBD.vistas_fechaEleccion);
		strSql.append(" AND ");
		strSql.append("fecharegistro").append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		params.add(param.getSindicato());
		params.add(param.getCodCentro());
		params.add(param.getTerritorio());
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFhist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		strSql.append(" AND (").append(W83bCertificacionesBD.fechabaja).append(" IS NULL ");
	    strSql.append(" OR ").append(W83bCertificacionesBD.fechabaja).append(" > TO_DATE(?,?))");
	    params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" GROUP BY ");
		strSql.append(W83bCertificacionesBD.vistas_numActa).append(",");
		strSql.append(W83bCertificacionesBD.vistas_fechaEleccion).append(",");
		strSql.append(W83bCertificacionesBD.vistas_descSindCast).append(",");
		strSql.append(W83bCertificacionesBD.vistas_descSindEusk);
		strSql.append(" ORDER BY ");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(" DESC ");
		
		List listaActas= W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,param.getUsuarioBean(),null);
		if(((listaActas.size()==1||listaActas.size()>1)&&Integer.parseInt(((W83bCertificacionesBean)listaActas.get(0)).getNumdelegados())==0)||listaActas.size()==1&&((W83bCertificacionesBean)listaActas.get(0)).getDescripcionSindicato()==null){
			W83bCertificacionesBean cert=(W83bCertificacionesBean)listaActas.get(0);
			param.setNumActa(cert.getNumActa());
			param.setFechaEleccion(cert.getFechaEleccion());
			param.setDescripcionSindicato(cert.getDescripcionSindicato());
			param.setDescripcionSindicatoEusk(cert.getDescripcionSindicatoEusk());
		}
		return param;	
	}
	public List cargaCertificacionPorSectores(W83bCertificacionesBean param) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
	    
	    List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bCertificacionesBD.codsector).append(", ");
		strSql.append(W83bCertificacionesBD.codsindi).append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descSindCast).append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descSindEusk).append(", ");
		strSql.append("SUM (");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(") AS ");
		strSql.append(W83bCertificacionesBD.vistas_delegados);
		strSql=this.rellenarFromWhereCertificacionPorSectores(strSql, param);
		strSql.append(" AND ");
		strSql.append(W83bCertificacionesBD.vers);
		strSql.append("=(SELECT MAX (ACT.");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(") FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE (ACT.");
		strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
		strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL) AND ACT.");
		strSql.append(W83bActasBD.anyoActa).append("=ANOACTA AND ACT.");
		strSql.append(W83bActasBD.numActa).append("=NACTA AND ACT.");
		strSql.append(W83bActasBD.codTerritActa).append("=TERRIT ");
		strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1)");
		strSql.append(" GROUP BY ");
		strSql.append(W83bCertificacionesBD.vistas_codSector);
		strSql.append(", ").append(W83bCertificacionesBD.codsindi);
		strSql.append(", ").append(W83bCertificacionesBD.vistas_descSindCast);
		strSql.append(", ").append(W83bCertificacionesBD.vistas_descSindEusk);
		strSql.append(" ORDER BY ").append(W83bCertificacionesBD.codsector);
		//Antonio 09/04/2013
		strSql.append(", ").append(W83bCertificacionesBD.vistas_delegados);
		strSql.append(" DESC");
		strSql.append(", ").append(W83bCertificacionesBD.vistas_descSindCast);
		//Fin Antonio
		params=this.rellenarParamsCertificacionPorSectores(param);
		
		List listaActas= W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,param.getUsuarioBean(),null);		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		return listaActas;	
	}
	public List cargaCertificacionPorSectoresTotales(W83bCertificacionesBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bCertificacionesBD.codsindi).append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descSindCast).append(", ");
		strSql.append(W83bCertificacionesBD.vistas_descSindEusk).append(", ");
		strSql.append("SUM (");
		strSql.append(W83bCertificacionesBD.numdelegados);
		strSql.append(") AS ");
		strSql.append(W83bCertificacionesBD.vistas_delegados);
		strSql=this.rellenarFromWhereCertificacionPorSectores(strSql, param);
		strSql.append(" AND ");
		strSql.append(W83bCertificacionesBD.vers);
		strSql.append("=(SELECT MAX (ACT.");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(") FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE (ACT.");
		strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
		strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL) AND ACT.");
		strSql.append(W83bActasBD.anyoActa).append("=ANOACTA AND ACT.");
		strSql.append(W83bActasBD.numActa).append("=NACTA AND ACT.");
		strSql.append(W83bActasBD.codTerritActa).append("=TERRIT ");
		strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1)");
		strSql.append(" GROUP BY ");
		strSql.append(W83bCertificacionesBD.codsindi);
		strSql.append(", ").append(W83bCertificacionesBD.vistas_descSindCast);
		strSql.append(", ").append(W83bCertificacionesBD.vistas_descSindEusk);
		//Antonio 09/04/2013
		strSql.append(" ORDER BY ").append(W83bCertificacionesBD.vistas_delegados);
		strSql.append(" DESC");
		strSql.append(", ").append(W83bCertificacionesBD.vistas_descSindCast);
		//Fin Antonio
		params=this.rellenarParamsCertificacionPorSectores(param);
		List listaActas= W83bDataBase.executeQuery(strSql.toString(),params,W83bCertificacionesBean.class,param.getUsuarioBean(),null);
		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		
		return listaActas;	
	}
	private List rellenarParamsCertificacionPorSectores(W83bCertificacionesBean param)
	{
		List params = new ArrayList();
		String[] codigos=param.getListaCodSector().split(",");
	
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		if(StringUtils.isNotEmpty(param.getTerritorio())&& !W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(param.getTerritorio()))
		{
			params.add(param.getTerritorio());
		}
		for(int i=0;i<codigos.length;i++){
	    	 params.add(codigos[i]);
	    }
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		return params;
	}
	private List rellenarParamsCertificacionCentSind(W83bCertificacionesBean param, String texto)
	{
		List params = new ArrayList();
		String[] codigos=param.getListaCodConvenios().split(",");
		if ("individual".equals(texto)){
			params.add(param.getSindicato());
		}
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaRegistroDefinitivo());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		for(int i=0;i<codigos.length;i++){
	    	 params.add(codigos[i]);
	    }
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		return params;
	}
	private List rellenarParamsCertificadoMasRepresentativo(W83bCertificacionesBean param, List params)
	{
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionDesde());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaEleccionHasta());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFechaRegistroDefinitivo());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFhist());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		return params;
	}
	private StringBuffer rellenarFromWhereCertificacionPorSectores(StringBuffer sql,W83bCertificacionesBean param)
	{
		
		
		String[] codigos=param.getListaCodSector().split(",");
		StringBuffer strSql=sql;
		strSql.append(" FROM ");
		strSql.append(W83bCertificacionesBD.vistaDelegadosSector);
		
		strSql.append(" WHERE ");
		strSql.append(" TO_DATE(?,?)<=");
		strSql.append(W83bCertificacionesBD.vistas_fechaElec);
	    strSql.append(" AND TO_DATE(?,?)>=").append(W83bCertificacionesBD.vistas_fechaElec);
	   
	    if(StringUtils.isNotEmpty(param.getTerritorio())&& !W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(param.getTerritorio()))
		{
			strSql.append(" AND ").append(W83bCertificacionesBD.vistas_codTerrit).append(" = ? ");
		}
			
	    for(int i=0;i<codigos.length;i++){
	    	if(i==0)
	    	{
	    		strSql.append(" AND ( ");
	    	}
	    	 strSql.append(W83bCertificacionesBD.vistas_codSector).append("=? ");
	    	 if(i!=codigos.length-1){
	    		 strSql.append(" OR ");
		    	}
	    	 if(i==codigos.length-1)
		    	{
		    		strSql.append(" ) ");
		    	}
	    }
	    strSql.append(" AND ");
		strSql.append(W83bCertificacionesBD.fregdef);
	    strSql.append("<=TO_DATE(?,?)");
	    strSql.append(" AND (");
	    strSql.append(W83bCertificacionesBD.fechabaja).append(" IS NULL ");		
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta()))
			{				
				strSql.append(" OR ");
				strSql.append(W83bCertificacionesBD.fechabaja).append(">").append("TO_DATE(?,?) ");				
			}
		strSql.append(" )");
		return strSql;
	}
	
	

}



